#
# setup_logging.py
#
import sys
import logging
from logging.handlers import TimedRotatingFileHandler

logger = logging.getLogger(__name__)

def setup_logging(logfile=None, backup_count=3): 
    logger = logging.getLogger()
    logger.handlers.clear()

    formatter = logging.Formatter(
        "[%(asctime)s] %(levelname)s [agent %(process)d/%(thread)d] "
        "%(module)s.%(funcName)s:%(lineno)d] %(message)s",
        "%d/%b/%Y %H:%M:%S",
    )

    if logfile != None:
        handler = TimedRotatingFileHandler(
            filename=logfile,
            when="midnight",
            backupCount=backup_count,
            encoding="utf-8",
            delay=True,
        )
    else:
        handler = logging.StreamHandler(sys.stderr)

    # Avoid duplicate handlers if setup called multiple times
    logger.handlers.clear()
    handler.setFormatter(formatter)
    logger.addHandler(handler)
    return logger

