# WinVM-WindowsUpdate-Toggle.ps1 (v1.0)
# Soft toggle for Windows Update (no ACL/SDDL hardening).
# -Mode Disable : disable wuauserv + disable WindowsUpdate tasks (Scheduled Start, sih, sihboot)
# -Mode Enable  : enable/start services + enable those tasks
# Compatible: Windows 10/11 (incl. LTSC). Run as Administrator.
# RunCmd:
# single command: 
#  powershell -ExecutionPolicy Bypass -File .\WinVM-WindowsUpdate-Enable.ps1
# multiple commans:
# Admin PowerShell
#	Set-ExecutionPolicy -Scope Process -ExecutionPolicy Bypass
#	.\WinVM-WindowsUpdate-Toggle.ps1 -Mode Disable
#	.\WinVM-WindowsUpdate-Toggle.ps1 -Mode Status
#	.\WinVM-WindowsUpdate-Toggle.ps1 -Mode Enable
# ASCII-only comments

param(
  [Parameter(Mandatory=$true)]
  [ValidateSet("Enable","Disable","Status")]
  [string]$Mode
)

$ErrorActionPreference = "Continue"
# include core 
. "$PSScriptRoot\WindowsUpdate-Core.ps1"

Set-WindowsUpdate-State -Mode $Mode