# Open urls in default web browser provided by circle agent
# Part of CIRCLE project http://circlecloud.org/
# Should be in autostart and run by the user logged in

import logging
from os.path import join
from os import environ
from notify import run_client, get_temp_dir

logger = logging.getLogger()
logfile = join(get_temp_dir(), "agent-client.log")
fh = logging.FileHandler(logfile)
formatter = logging.Formatter(
    "%(asctime)s - %(name)s [%(levelname)s] %(message)s")
fh.setFormatter(formatter)
logger.addHandler(fh)
level = environ.get('LOGLEVEL', 'INFO')
logger.setLevel(level)


if __name__ == '__main__':
    run_client()
