## from twisted.internet.defer import Deferred
#from twisted.internet import reactor  # threads
#from celery.result import TimeoutError
from celery import Celery
import serializers
from kombu import Queue, Exchange
from os import getenv
#from socket import gethostname
#from threading import Event
import logging
from celery.utils.log import get_task_logger
#from celery.signals import after_setup_task_logger
#from celery.app.log import TaskFormatter

logger = get_task_logger(__name__)

QUEUE_NAME = "localhots.man" 
AMQP_URI = getenv('AMQP_URI')

celery = Celery('agentman', broker=AMQP_URI)

celery.config_from_object('celeryconfig')

celery.conf.update(
           CELERY_QUEUES=(Queue(QUEUE_NAME, Exchange('manager', type='direct'),
                                        routing_key='manager'), ),
           task_protocol = 1,        # Celery 3 compatibility
           task_serializer='json',
           accept_content=['json'],  # Ignore other content
           result_serializer='json',
           timezone='UTC',
           enable_utc=True,)


@celery.task(name='vm.tasks.local_agent_tasks.renew')
def renew(vm):
    pass


@celery.task(name='vm.tasks.local_agent_tasks.agent_started')
def agent_started(vm, version, system):
    pass


@celery.task(name='vm.tasks.local_agent_tasks.agent_stopped')
def agent_stopped(vm):
    pass


@celery.task(name='vm.tasks.local_agent_tasks.agent_ok')
def agent_ok(vm):
    pass
