#!/usr/bin/env bash
set -euo pipefail

if [[ $EUID -ne 0 ]]; then
  echo "Kérlek rootként futtasd: sudo ./minimal-comfort.sh"
  exit 1
fi

export DEBIAN_FRONTEND=noninteractive

echo "[*] APT frissítés + alap csomagok telepítése..."
apt-get update -y
apt-get install -y \
  iproute2 iputils-ping net-tools dnsutils \
  curl wget ca-certificates \
  less lsof traceroute tcpdump \
  nano vim htop \
  unzip zip tar gzip bzip2 xz-utils \
  git jq rsync \
  isc-dhcp-client

# VLAN modul (802.1Q)
echo "[*] 8021q modul engedélyezése (VLAN-hoz)..."
install -d /etc/modules-load.d
echo "8021q" > /etc/modules-load.d/vlan-8021q.conf
modprobe 8021q || true

# Kényelmi aliasok és kisegítők (globálisan minden usernek)
echo "[*] Aliasok és kényelmi beállítások hozzáadása..."
cat >/etc/profile.d/99-comfort.sh <<'EOC'
# Komfort aliasok
alias ll='ls -alF'
alias la='ls -A'
alias l='ls -CF'
alias grep='grep --color=auto'
alias ipw='ip -c -br a'
alias ports='ss -tulpen'

# kevésbé idegesítő less
export LESS='-R'

# default editor
export EDITOR=vim

# Egyszerű, informatív prompt
# pl: [root@host 12:34] /current/dir $
if [ -n "$PS1" ]; then
  PS1='[\u@\h \A] \w \$ '
fi
EOC

chmod 0644 /etc/profile.d/99-comfort.sh

# Vim alap beállítás (ha valaki inkább ezt használja)
cat >/etc/vim/vimrc.local <<'EOV'
set number
set ruler
set mouse=
set backspace=indent,eol,start
syntax on
EOV

# Nano: egységes tab/indent és sorjelölés
install -d /etc/nano
cat >/etc/nanorc <<'EON'
set linenumbers
set tabsize 2
set smooth
set nowrap
EON

echo
echo "[✓] Kész! Lépj ki és be újra (vagy futtasd: source /etc/profile) az aliasokhoz/prompthoz."
echo "[i] Hasznos parancsok:"
echo "    - ipw            # rövid IP összefoglaló"
echo "    - ports          # nyitott portok/folyamatok"
echo "    - dhclient IFACE # DHCP kliens kézzel (pl. dhclient enp3s0.5)"
