from openstack.exceptions import ResourceNotFound

from interface.image.ImageManager import ImageManager
from interface.image.Image import Image


class OpenstackImageManager(ImageManager):

    def __init__(self, openstack) -> None:
        super().__init__()

        self.openstack = openstack

    @staticmethod
    def os_image_to_rc_image(os_image):
        return Image(
            os_image.id,
            os_image.name,
            os_image.disk_format
        )

    def upload_file(self, name, path, format):
        os_image = self.openstack.image.create_image(
            name=name,
            filename=path,
            disk_format=format
        )

        return self.os_image_to_rc_image(os_image)

    def get(self, id):
        try:
            os_image = self.openstack.image.get_image(id)
        except ResourceNotFound:
            return None

        return self.os_image_to_rc_image(os_image)

    def download(self, id):
        return self.openstack.image.download_image(id)

    def delete(self, id):
        try:
            self.openstack.image.delete_image(id)
        except ResourceNotFound:
            return False

        return True

    def list(self):
        images = []

        for os_image in self.openstack.image.images():
            images.append(self.os_image_to_rc_image(os_image))

        return images
