from interface_openstack.interface.vm.instance import InstanceInterface
from interface_openstack.interface.vm.resources import Instance, Flavor
from openstack.exceptions import SDKException
from novaclient import client
import logging
from keystoneauth1.identity import v3
from keystoneauth1 import session

auth = v3.Password(auth_url="http://10.34.0.113/identity/v3",
                   username="admin",
                   password="64c7ee341d03844c548c",
                   user_domain_id='default',
                   project_id="2db5309f541c4466bc80bc534cf579d7")

sess = session.Session(auth=auth)


def openstackError(func):
    def wrap_OpenStackError(*args, **kw):
        """ Decorator to wrap openstack error in simple Exception.
        Return decorated function

        """
        try:
            return func(*args, **kw)
        except SDKException as e:
                logging.error(e)
                new_e = Exception(e)
                new_e.OpenStackError = True
                raise new_e
    return wrap_OpenStackError


class OSVirtualMachineManager(InstanceInterface):

    def __init__(self, cloud):
        super().__init__()
        self.openstack = cloud

    @openstackError
    def create_base_vm(self, name, flavor, networks, block_dev_map):
        devices = []
        b_device = block_dev_map.__dict__
        devices.append(b_device)
        flavor = self.get_flavor(flavor)
        new_server = self.openstack.compute.create_server(name=name,
                                                          flavorRef=flavor.id,
                                                          networks=networks,
                                                          block_device_mapping=devices
                                                          )
        return self.convert_server_to_instance(new_server)

    @openstackError
    def create_vm_from_template(self, name, image, flavor, networks):
        return self.create_multiple_vm_from_template(name, image, flavor, networks, 1)

    @openstackError
    def create_multiple_vm_from_template(self, name, image, flavor, networks,
                                         number, **args):
        compute = self.openstack.compute
        flav = compute.find_flavor(flavor)

        image = compute.find_image(image)
        if not image:
            raise ValueError("The template not found")

        new_server = compute.create_server(name=name,
                                           flavorRef=flav.id,
                                           imageRef=image.id,
                                           networks=networks,
                                           min_count=number,
                                           )
        return self.convert_server_to_instance(new_server)

    @openstackError
    def create_flavor(self, name, ram, vcpus, initial_disk):
        flavor = self.openstack.compute.create_flavor(name=name,
                                                      ram=ram,
                                                      vcpus=vcpus,
                                                      disk=initial_disk)
        return Flavor(flavor.name, flavor.id, flavor.ram,
                      flavor.vcpus, flavor.disk)

    @openstackError
    def get_flavor(self, flavor_id):
        flavor = self.openstack.compute.find_flavor(flavor_id)
        return Flavor(flavor.name, flavor.id, flavor.ram,
                      flavor.vcpus, flavor.disk)

    @openstackError
    def delete_flavor(self, flavor_id):
        flavor = self.openstack.compute.find_flavor(flavor_id)
        self.openstack.compute.delete_flavor(flavor)

    @openstackError
    def list_flavors(self):
        flavors = []
        for flavor in self.openstack.compute.flavors():
            flavors.append(Flavor(flavor.name, flavor.id, flavor.ram,
                                  flavor.vcpus, flavor.disk))
        return flavors

    @openstackError
    def get_vm(self, name_or_id=None):
        if not name_or_id:
            raise ValueError("Name or id doesn't given")
        server_instance = self.openstack.compute.get_server(name_or_id)
        if not server_instance:
            raise ValueError("Could not get the vm")
        return self.convert_server_to_instance(server_instance)

    @openstackError
    def start_vm(self, name_or_id=None):
        if name_or_id:
            instance = self.openstack.compute.get_server(name_or_id)
        self.openstack.compute.start_server(instance)

    @openstackError
    def stop_vm(self, name_or_id=None):
        if name_or_id:
            instance = self.openstack.compute.get_server(name_or_id)
        self.openstack.compute.stop_server(instance)

    @openstackError
    def suspend_vm(self, name_or_id=None):
        if name_or_id:
            instance = self.openstack.compute.get_server(name_or_id)
        self.openstack.compute.suspend_server(instance)

    @openstackError
    def wake_up_vm(self, name_or_id=None):
        if name_or_id:
            instance = self.openstack.compute.get_server(name_or_id)
        self.openstack.compute.resume_server(instance)

    @openstackError
    def reboot_vm(self, name_or_id):
        if name_or_id:
            instance = self.openstack.compute.get_server(name_or_id)
        self.openstack.compute.reboot_server(instance, reboot_type='SOFT')

    @openstackError
    def reset_vm(self, name_or_id):
        if name_or_id:
            instance = self.openstack.compute.get_server(name_or_id)
        self.openstack.compute.reboot_server(instance, reboot_type='HARD')

    @openstackError
    def destroy_vm(self, name_or_id):
        if name_or_id:
            instance = self.openstack.compute.get_server(name_or_id)
        self.openstack.compute.delete_server(instance)

    @openstackError
    def get_status(self, name_or_id):
        if name_or_id:
            instance = self.openstack.compute.get_server(name_or_id)
        return instance.status

    @openstackError
    def list_all_vm(self):
        servers = []
        for server in self.openstack.compute.servers():
            servers.append(self.convert_server_to_instance(server))
        return servers

    @openstackError
    def resize_vm(self, name_or_id, resource):
        if name_or_id:
            instance = self.openstack.get_server(name_or_id)
        flavor = self.openstack.compute.find_flavor(resource['name'])

        self.openstack.compute.resize_server(instance, flavor)

    @openstackError
    def create_template(self, name_or_id, template_name, metadata=None):
        if name_or_id:
            instance = self.openstack.compute.get_server(name_or_id)
        self.openstack.compute.create_server_image(instance,
                                                   template_name,
                                                   metadata)

    def get_vnc_console(self, server_id):
        with client.Client("2", session=sess) as nova:
            if server_id:
                instance = nova.servers.get(server_id)
                return instance.get_vnc_console("novnc")

    @openstackError
    def attach_volume(self, server_id, volume_id, device=None):
        self.openstack.compute.create_volume_attachment(server_id,
                                                        {"volumeId": volume_id,
                                                         })

    @openstackError
    def detach_volume(self, server_id, volume_id, device=None):
        self.openstack.compute.delete_volume_attachment(server_id,
                                                        {"volumeId": volume_id,
                                                         "device": device
                                                         })

    def convert_server_to_instance(self, server):
        if not server.image:
            image_id = None
        else:
            image_id = server.image_id
        return Instance(id=server.id,
                        flavor=server.flavor_id,
                        name=server.name,
                        image_id=image_id,
                        disks=server.attached_volumes,
                        status=server.status,
                        launched_at=server.launched_at,
                        terminated_at=server.terminated_at,
                        addresses=server.addresses)
