"""
General interface for using the CIRCLE portal API
It should be implemented for using other providers e. g. OpenStack

"""


class InstanceInterface:

    def create_base_vm(self, name, flavor, networks, block_device_mapping):
        raise NotImplementedError

    def create_vm_from_template(self, name, image, flavor, networks):
        raise NotImplementedError

    def create_multiple_vm_from_template(self, image, flavor, networks, number):
        raise NotImplementedError

    def get_vm(self, name_or_id):
        raise NotImplementedError

    def start_vm(self, name_or_id):
        raise NotImplementedError

    def stop_vm(self, name_or_id):
        raise NotImplementedError

    def suspend_vm(self, name_or_id):
        raise NotImplementedError

    def wake_up_vm(self, name_or_id):
        raise NotImplementedError

    def shut_off_vm(self, name_or_id):
        raise NotImplementedError

    def reboot_vm(self, name_or_id):
        raise NotImplementedError

    def reset_vm(self, name_or_id):
        raise NotImplementedError

    def destroy_vm(self, name_or_id):
        raise NotImplementedError

    def get_status(self, name_or_id):
        raise NotImplementedError

    def list_all_vm(self):
        raise NotImplementedError

    def install_ssh_key(self, name_or_id, key):
        raise NotImplementedError

    def get_vnc_console(self, name_or_id):
        raise NotImplementedError

    def change_password(self, name_or_id):
        raise NotImplementedError

    def get_password(self, name_or_id):
        raise NotImplementedError

    def resize_vm(self, name_or_id):
        raise NotImplementedError

    def create_template(self, name_or_id, template_name):
        raise NotImplementedError

    def attach_volume(self, name_or_id, amount):
        raise NotImplementedError
