import json


class Instance:
    ''' The releveant data of the virtual machine instances
        This data would be sent by the interface to the portal,
        when it requests a virtual machine instance and vica versa
    '''

    ssh_keys = None
    console_access_url = None

    def __init__(self, id, name, flavor, image_id, status,
                 addresses, launched_at, terminated_at, disks=None):
        self.id = id
        self.name = name
        self.flavor = flavor
        self.image = image_id
        self.disks = disks
        self.status = status
        self.addresses = addresses
        self.launched_at = launched_at
        self.terminated_at = terminated_at

    def JSON(self):
        return json.dumps(self.__dict__)


class Flavor:
    def __init__(self, name, id, ram, vcpus, disk):
        self.id = id
        self.name = name
        self.ram = ram
        self.vcpus = vcpus
        self.initial_disk = disk

    def JSON(self):
        return json.dumps(self.__dict__)


class BlockDeviceMapping:
    def __init__(self, boot_index, uuid, source_type, volume_size,
                 destination_type, delete_on_termination, disk_bus):
        self.boot_index = boot_index
        self.uuid=uuid
        self.source_type=source_type
        self.volume_size=volume_size
        self.destination_type=destination_type
        self.delete_on_termination=delete_on_termination
        self.disk_bus=disk_bus

    def JSON(self):
        return json.dumps(self.__dict__)
