# This file is for testing the openstack api access
from implementation.vm.instance import OSVirtualMachineManager
from interface.vm.resources import BlockDeviceMapping, Flavor
import openstack

# openstack.enable_logging(debug=True)

conn = openstack.connect(cloud='openstack')

block_dev_map = BlockDeviceMapping(
    boot_index=0,
    uuid="da51253f-867c-472d-8ce0-81e7b7126d60",
    source_type="image",
    volume_size=10,
    destination_type="volume",
    delete_on_termination=True,
    disk_bus="scsi"
)
networks = [{"uuid": "c03d0d4b-413e-4cc6-9ebe-c0b5ca0dac3a"}]

interface = OSVirtualMachineManager(conn)
print('#'*40)

# interface.create_vm_from_template('new_server', resource, "cirros-0.4.0-x86_64-disk")
# interface.stop_vm('a6bc504f-a422-4492-b429-e5dad2df12f4')
# server = interface.openstack.compute.get_server("8e94c162-f8ed-4872-b9e5-50bf33040b5b")
#
# print(server)
# print(interface.delete_flavor("flavorTest"))

for flavor in interface.list_flavors():
    print(flavor.JSON())

for vm in interface.list_all_vm():
    print(vm.JSON())
print("*" * 50)

print(interface.create_base_vm("BaseTest", "2", networks, block_dev_map).JSON())


# print(interface.convert_server_to_instance(server).JSON())

# print(interface.openstack.compute.get_server("8e94c162-f8ed-4872-b9e5-50bf33040b5b"))

# print(server.JSON())

# print(interface.get_vnc_console("8e94c162-f8ed-4872-b9e5-50bf33040b5b"))

# print(interface.convert_server_to_instance(server))

# print(interface.get_vnc_console("New test"))

# interface.create_template("New test", "test_template")
# interface.create_vm_from_template("test_template", resource, [{"uuid": "c03d0d4b-413e-4cc6-9ebe-c0b5ca0dac3a"}])
# interface.resize_vm(server, resource)
# interface.reboot_vm(server.id)

# interface.reset_vm(server.id)

# interface.suspend_vm(server.id)

# interface.wake_up_vm(server.id)

# interface.destroy_vm(server.id)
