import unittest
from unittest.mock import MagicMock
from implementation.vm.instance import OSVirtualMachineManager
from interface.vm.resources import Instance

servers = [
    MagicMock(
        id="test1",
        name="test1",
        flavorRef="flav1",
        imageRef="image1",
        networks= [{"uuid": "network1"}],
        terminated_at="20200320-15-31",
        launched_at="20190510-13-22",
        disks=["disk1"],
        status="ACTIVE",
        addresses=[{"mac": "12345678AB", "ipv4": "1.1.1.1"}]
    )
]


class MockOpenStackCompute(MagicMock):
    def setUp(self):
        self.compute = MagicMock()
        self.compute.create_server = MagicMock(return_value=servers[0])
        self.compute.find_flavor = MagicMock(return_value=MagicMock(id="uuid1"))
        self.compute.find_image = MagicMock(return_value=MagicMock(id="uuid2"))
        self.compute.wait_for_server = MagicMock(return_value=True)
        self.compute.list_servers = MagicMock(return_value=servers)


class InstanceCreateTestCase(unittest.TestCase):
    def setUp(self):
        self.conn = MockOpenStackCompute()
        self.conn.setUp()

        self.manager = OSVirtualMachineManager(self.conn)

    def tearDown(self):
        pass

    def test_create_from_template(self):
        instance = self.manager.create_vm_from_template('test', 'imageid', 'flavorid',
                                             ['networkid1'])
        self.conn.compute.create_server.assert_called()

    def test_create_from_template_params(self):
        self.manager.create_vm_from_template('test', 'imageid', 'flavorid',
                                             ['networkid1'])
        self.conn.compute.create_server.assert_called_with(
                                                        name='test',
                                                        flavorRef="uuid1",
                                                        imageRef="uuid2",
                                                        networks=['networkid1'],
                                                        min_count=1)
