from openstack.exceptions import ResourceNotFound

from interface.storage.Snapshot import Snapshot
from interface.storage.SnapshotManager import SnapshotManager


class OpenstackSnapshotManager(SnapshotManager):

    def __init__(self, os) -> None:
        super().__init__()

        self.openstack = os

    @staticmethod
    def os_snapshot_to_rc_snapshot(os_snapshot):
        return Snapshot(
            os_snapshot.id,
            os_snapshot.volume_id,
            os_snapshot.size,
            os_snapshot.status,
            os_snapshot.created_at
        )

    def create_from_volume(self, id):
        os_snapshot = self.openstack.block_storage.create_snapshot(volume_id=id)

        return self.os_snapshot_to_rc_snapshot(os_snapshot)

    def get(self, id):
        try:
            os_snapshot = self.openstack.block_storage.get_snapshot(id)
        except ResourceNotFound:
            return None

        return self.os_snapshot_to_rc_snapshot(os_snapshot)

    def list(self):
        snapshots = []

        for os_snapshot in self.openstack.block_storage.snapshots():
            snapshots.append(self.os_snapshot_to_rc_snapshot(os_snapshot))

        return snapshots

    def delete(self, id):
        try:
            self.openstack.block_storage.delete_snapshot(id)
        except ResourceNotFound:
            return False

        return True
