# Generated by Django 3.0.4 on 2020-04-06 12:09

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('image', '0001_initial'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Flavor',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100)),
                ('description', models.CharField(blank=True, max_length=200)),
                ('remote_id', models.CharField(help_text='ID of the instance on the backend', max_length=100)),
                ('ram', models.PositiveIntegerField(default=0)),
                ('vcpu', models.PositiveIntegerField(default=0)),
                ('initial_disk', models.PositiveIntegerField(default=0)),
                ('priority', models.PositiveIntegerField(blank=True, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Lease',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100)),
                ('description', models.CharField(blank=True, max_length=100)),
                ('suspend_interval_in_sec', models.IntegerField(default=3600)),
                ('delete_interval_in_sec', models.IntegerField(default=7200)),
            ],
        ),
        migrations.CreateModel(
            name='BaseMachineDescriptor',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text='Human readable name of template.', max_length=100, verbose_name='name')),
                ('description', models.TextField(blank=True, help_text='Description of the template.', verbose_name='description')),
                ('system_type', models.CharField(choices=[('LINUX', 'The system based on Linux'), ('WINDOWS', 'Windows based system')], help_text='The base name of the operating system', max_length=50, verbose_name='operating_system')),
                ('distro', models.CharField(blank=True, help_text='The specific name and version of the installed OSe. g. Win 7, Ubuntu 18.04', max_length=100, verbose_name='system distribution')),
                ('access_protocol', models.CharField(choices=[('rdp', 'Remote Desktop Protocol'), ('ssh', 'Secure Shell')], help_text='The protocol which used to connect to the machinethat created from this template', max_length=50, verbose_name='remote_access_protocol')),
                ('created_at', models.DateTimeField(auto_now_add=True, help_text='Date, when the template created.')),
                ('network_id', models.CharField(blank=True, help_text='The new instance will be in this network.', max_length=100, null=True, verbose_name='network_id')),
                ('created_by', models.ForeignKey(help_text='The user, who create the template', on_delete=django.db.models.deletion.DO_NOTHING, related_name='created_templates', to=settings.AUTH_USER_MODEL)),
                ('flavor', models.ForeignKey(help_text='Resources given to the vm', on_delete=django.db.models.deletion.CASCADE, related_name='templates', to='instance.Flavor', verbose_name='flavor')),
                ('lease', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='templates', to='instance.Lease')),
            ],
        ),
        migrations.CreateModel(
            name='Instance',
            fields=[
                ('basemachinedescriptor_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='instance.BaseMachineDescriptor')),
                ('remote_id', models.CharField(help_text='ID of the instance on the backend', max_length=100)),
                ('password', models.CharField(help_text='Original password of the instance', max_length=50)),
                ('time_of_suspend', models.DateTimeField(blank=True, help_text='After this point in time, the instance will be suspended')),
                ('time_of_delete', models.DateTimeField(blank=True, help_text='After this point in time, the instance will be deleted!')),
                ('status', models.CharField(default='NO_STATE', max_length=50, verbose_name='instance_status')),
                ('deleted', models.BooleanField(default=False, help_text='Indicates if the instance is ready for garbage collection')),
                ('disks', models.ManyToManyField(help_text='Disks attached to instance', related_name='instance', to='image.Disk', verbose_name='disks')),
                ('owner', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'permissions': (('create_instance', 'Can create a new VM.'), ('create_template_from_instance', 'Can create template from instance.'), ('use_instance', 'Can access the VM connection info.'), ('operate_instance', 'Can use basic lifecycle methods of the VM.'), ('administer_instance', 'Can delete VM.'), ('access_console', 'Can access the graphical console of a VM.'), ('change_resources', 'Can change resources of a VM.'), ('manage_access', 'Can manage access rights for the VM.'), ('config_ports', 'Can configure port forwards.')),
                'default_permissions': (),
            },
            bases=('instance.basemachinedescriptor',),
        ),
    ]
