from rest_framework import serializers
from .models import Flavor, Instance, Lease


class FlavorSerializer(serializers.ModelSerializer):
    class Meta:
        model = Flavor
        fields = "__all__"


class LeaseSerializer(serializers.ModelSerializer):
    class Meta:
        model = Lease
        fields = "__all__"


class InstanceListItemSerializer(serializers.ModelSerializer):
    lease = LeaseSerializer(read_only=True)

    class Meta:
        model = Instance
        fields = ["id", "name", "status", "system_type", "distro", "status", "lease"]


class InstanceSerializer(serializers.ModelSerializer):
    lease = serializers.PrimaryKeyRelatedField(read_only=True)
    flavor = serializers.PrimaryKeyRelatedField(read_only=True)

    class Meta:
        model = Instance
        fields = "__all__"
        read_only_fields = ("id", "status" "password", "template",
                            "time_of_suspend", "time_of_delete")
