#!/bin/bash
## This file used by the gitlab ci runner
## Reads the environment variables from the CI config then echoes it to the .env file
# This variables are interpreted automatically by the Docker Engine
# And by the Django runtime
# Django configuration
echo DJANGO_SECRET=${DJANGO_SECRET} >> .env
# If using other database than sqlite3 (only use sqlite for development!)
# Provide the db credentials here
echo DATABASE_PASSWORD=${DATABASE_PASSWORD} >> .env
echo DATABASE_USER=${DATABASE_USER} >> .env
echo DATABASE_NAME=${DATABASE_NAME} >> .env
echo DATABASE_HOST=${DATABASE_HOST} >> .env
# For channels communication and periodic tasks we need a redis server
echo REDIS_HOST=${REDIS_HOST} >> .env
# OpenStack credentials
# In development we recommend using a DevStack installation
# These settings displayed in an admin dashboard or
# Can be downloaded from Horizon, as an admin user
echo OS_AUTH_URL=${OS_AUTH_URL} >> .env
echo OS_PROJECT_ID=${OS_PROJECT_ID} >> .env
echo OS_PROJECT_NAME=${OS_PROJECT_NAME} >> .env
echo OS_USER_DOMAIN_NAME=${OS_USER_DOMAIN_NAME} >> .env
echo OS_USER_DOMAIN_ID=${OS_USER_DOMAIN_ID} >> .env
echo OS_PROJECT_DOMAIN_ID=${OS_PROJECT_DOMAIN_ID} >> .env
echo OS_USERNAME=${OS_USERNAME} >> .env
echo OS_PASSWORD=${OS_PASSWORD} >> .env
echo OS_REGION_NAME=${OS_REGION_NAME} >> .env
echo OS_INTERFACE=${OS_INTERFACE} >> .env
echo OS_IDENTITY_API_VERSION=${OS_IDENTITY_API_VERSION} >> .env