from rest_framework import serializers

from .models import Image


class ImageUpdateSerializer(serializers.Serializer):
    name = serializers.CharField(required=False)
    description = serializers.CharField(required=False)


class ImageSerializer(serializers.ModelSerializer):
    image_file = serializers.FileField(write_only=True)
    file_format = serializers.CharField(max_length=10)
    size = serializers.IntegerField(read_only=True)

    class Meta:
        model = Image
        fields = (
            "name",
            "remote_id",
            "description",
            "image_file",
            "file_format",
            "created_at",
            "uploaded_by_user",
            "created_by",
            "id",
            "size",
        )
        read_only_fields = ("created_at", "uploaded_by_user", "created_by", "remote_id", "size", )
